/**
 * SMS Ayarları tablosunu Vatan SMS yapısına güncelleme scripti
 * Kullanım: npm run migrate-sms-vatansms
 */

const mysql = require("mysql2/promise");
const dotenv = require("dotenv");
const path = require("path");

// .env dosyasını yükle
dotenv.config({ path: path.resolve(__dirname, "../.env.local") });

async function migrateSMSToVatanSMS() {
  const config = {
    host: process.env.DB_HOST || "localhost",
    port: parseInt(process.env.DB_PORT || "3306"),
    user: process.env.DB_USER || "root",
    password: process.env.DB_PASSWORD || "",
    multipleStatements: true,
    insecureAuth: true,
  };

  const dbName = process.env.DB_NAME || "teknik_servis";

  try {
    console.log("Veritabanı bağlantısı kuruluyor...");

    const connection = await mysql.createConnection(config);
    await connection.query(`USE ${dbName}`);

    // Önce mevcut kolonları kontrol et
    const [columns]: any = await connection.query(`
      SELECT COLUMN_NAME 
      FROM INFORMATION_SCHEMA.COLUMNS 
      WHERE TABLE_SCHEMA = ? AND TABLE_NAME = 'sms_ayarlari'
    `, [dbName]);

    const columnNames = columns.map((col: any) => col.COLUMN_NAME);

    // Eski kolonları yeni kolonlara dönüştür
    if (columnNames.includes('api_kullanici_adi') && !columnNames.includes('api_id')) {
      console.log("Kolonlar güncelleniyor...");
      await connection.query(`
        ALTER TABLE sms_ayarlari 
        CHANGE COLUMN api_kullanici_adi api_id VARCHAR(255),
        CHANGE COLUMN api_sifre api_key VARCHAR(255),
        MODIFY COLUMN api_url VARCHAR(255) DEFAULT 'https://api.vatansms.net/api/v1'
      `);
      console.log("✅ Kolonlar başarıyla güncellendi!");
    } else if (!columnNames.includes('api_id')) {
      // Eğer tablo yoksa veya kolonlar farklıysa
      console.log("Yeni kolonlar ekleniyor...");
      if (!columnNames.includes('api_id')) {
        await connection.query(`ALTER TABLE sms_ayarlari ADD COLUMN api_id VARCHAR(255) AFTER id`);
      }
      if (!columnNames.includes('api_key')) {
        await connection.query(`ALTER TABLE sms_ayarlari ADD COLUMN api_key VARCHAR(255) AFTER api_id`);
      }
      await connection.query(`ALTER TABLE sms_ayarlari MODIFY COLUMN api_url VARCHAR(255) DEFAULT 'https://api.vatansms.net/api/v1'`);
      console.log("✅ Yeni kolonlar eklendi!");
    } else {
      console.log("✅ Tablo zaten güncel!");
    }

    await connection.end();

    console.log("✅ Migration tamamlandı!");
  } catch (error: any) {
    console.error("❌ Hata:", error.message);
    process.exit(1);
  }
}

migrateSMSToVatanSMS();

