/**
 * SMTP Bilgileri tablosu oluşturma scripti
 * Kullanım: npm run create-smtp-table
 */

const mysql = require("mysql2/promise");
const dotenv = require("dotenv");
const path = require("path");

// .env dosyasını yükle
dotenv.config({ path: path.resolve(__dirname, "../.env.local") });

async function createSMTPBilgileriTable() {
  const config = {
    host: process.env.DB_HOST || "localhost",
    port: parseInt(process.env.DB_PORT || "3306"),
    user: process.env.DB_USER || "root",
    password: process.env.DB_PASSWORD || "",
    multipleStatements: true,
    insecureAuth: true,
  };

  const dbName = process.env.DB_NAME || "teknik_servis";

  try {
    console.log("Veritabanı bağlantısı kuruluyor...");

    const connection = await mysql.createConnection(config);
    await connection.query(`USE ${dbName}`);

    // SMTP Bilgileri tablosunu oluştur
    console.log("SMTP Bilgileri tablosu oluşturuluyor...");
    await connection.query(`
      CREATE TABLE IF NOT EXISTS smtp_bilgileri (
        id INT AUTO_INCREMENT PRIMARY KEY,
        smtp_host VARCHAR(255),
        smtp_port INT DEFAULT 587,
        smtp_kullanici_adi VARCHAR(255),
        smtp_sifre VARCHAR(255),
        smtp_guvenlik ENUM('none', 'ssl', 'tls') DEFAULT 'tls',
        gonderici_email VARCHAR(255),
        gonderici_adi VARCHAR(255),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
      ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    `);

    // Eğer tablo boşsa, varsayılan bir kayıt ekle
    const [rows]: any = await connection.query("SELECT COUNT(*) as count FROM smtp_bilgileri");
    if (rows[0].count === 0) {
      console.log("Varsayılan kayıt ekleniyor...");
      await connection.query(`
        INSERT INTO smtp_bilgileri (
          smtp_host, smtp_port, smtp_kullanici_adi, smtp_sifre, 
          smtp_guvenlik, gonderici_email, gonderici_adi
        ) VALUES (
          '', 587, '', '', 'tls', '', ''
        );
      `);
    }

    await connection.end();

    console.log("✅ SMTP Bilgileri tablosu başarıyla oluşturuldu!");
  } catch (error: any) {
    console.error("❌ Hata:", error.message);
    process.exit(1);
  }
}

createSMTPBilgileriTable();

