/**
 * SMS Ayarları tablosu oluşturma scripti
 * Kullanım: npm run create-sms-table
 */

const mysql = require("mysql2/promise");
const dotenv = require("dotenv");
const path = require("path");

// .env dosyasını yükle
dotenv.config({ path: path.resolve(__dirname, "../.env.local") });

async function createSMSAyarlariTable() {
  const config = {
    host: process.env.DB_HOST || "localhost",
    port: parseInt(process.env.DB_PORT || "3306"),
    user: process.env.DB_USER || "root",
    password: process.env.DB_PASSWORD || "",
    multipleStatements: true,
    insecureAuth: true,
  };

  const dbName = process.env.DB_NAME || "teknik_servis";

  try {
    console.log("Veritabanı bağlantısı kuruluyor...");

    const connection = await mysql.createConnection(config);
    await connection.query(`USE ${dbName}`);

    // SMS Ayarları tablosunu oluştur
    console.log("SMS Ayarları tablosu oluşturuluyor...");
    await connection.query(`
      CREATE TABLE IF NOT EXISTS sms_ayarlari (
        id INT AUTO_INCREMENT PRIMARY KEY,
        api_id VARCHAR(255),
        api_key VARCHAR(255),
        sms_baslik VARCHAR(100),
        api_url VARCHAR(255) DEFAULT 'https://api.vatansms.net/api/v1',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
      ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    `);

    // Eğer tablo boşsa, varsayılan bir kayıt ekle
    const [rows]: any = await connection.query("SELECT COUNT(*) as count FROM sms_ayarlari");
    if (rows[0].count === 0) {
      console.log("Varsayılan kayıt ekleniyor...");
      await connection.query(`
        INSERT INTO sms_ayarlari (
          api_id, api_key, sms_baslik, api_url
        ) VALUES (
          '', '', '', 'https://api.vatansms.net/api/v1'
        );
      `);
    }

    await connection.end();

    console.log("✅ SMS Ayarları tablosu başarıyla oluşturuldu!");
  } catch (error: any) {
    console.error("❌ Hata:", error.message);
    process.exit(1);
  }
}

createSMSAyarlariTable();

