/**
 * Panel Ayarları tablosu oluşturma scripti
 * Kullanım: npm run create-panel-ayarlari-table
 */

const mysql = require("mysql2/promise");
const dotenv = require("dotenv");
const path = require("path");

// .env dosyasını yükle
dotenv.config({ path: path.resolve(__dirname, "../.env.local") });

async function createPanelAyarlariTable() {
  const config = {
    host: process.env.DB_HOST || "localhost",
    port: parseInt(process.env.DB_PORT || "3306"),
    user: process.env.DB_USER || "root",
    password: process.env.DB_PASSWORD || "",
    multipleStatements: true,
    insecureAuth: true,
  };

  const dbName = process.env.DB_NAME || "teknik_servis";

  try {
    console.log("Veritabanı bağlantısı kuruluyor...");

    const connection = await mysql.createConnection(config);
    await connection.query(`USE ${dbName}`);

    // Panel Ayarları tablosunu oluştur
    console.log("Panel Ayarları tablosu oluşturuluyor...");
    await connection.query(`
      CREATE TABLE IF NOT EXISTS panel_ayarlari (
        id INT AUTO_INCREMENT PRIMARY KEY,
        panel_adi VARCHAR(255) NOT NULL,
        logo VARCHAR(500),
        stok_uyari_limiti INT DEFAULT 0,
        izin_verilen_dosya_turleri VARCHAR(255),
        hizmet_kdv_orani DECIMAL(5,2) DEFAULT 0.00,
        urun_kdv_orani DECIMAL(5,2) DEFAULT 0.00,
        para_birimi VARCHAR(10) DEFAULT 'TRY',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
      ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    `);

    // Eğer tablo boşsa, varsayılan bir kayıt ekle
    const [rows]: any = await connection.query("SELECT COUNT(*) as count FROM panel_ayarlari");
    if (rows[0].count === 0) {
      console.log("Varsayılan kayıt ekleniyor...");
      await connection.query(`
        INSERT INTO panel_ayarlari (
          panel_adi, logo, stok_uyari_limiti, izin_verilen_dosya_turleri,
          hizmet_kdv_orani, urun_kdv_orani, para_birimi
        ) VALUES (
          'Teknik Servis Paneli', '', 10, 'jpg,png,pdf,doc,docx', 20.00, 20.00, 'TRY'
        );
      `);
    }

    await connection.end();

    console.log("✅ Panel Ayarları tablosu başarıyla oluşturuldu!");
  } catch (error: any) {
    console.error("❌ Hata:", error.message);
    process.exit(1);
  }
}

createPanelAyarlariTable();


