/**
 * Firma Bilgileri tablosu oluşturma scripti
 * Kullanım: npm run create-firma-table
 */

const mysql = require("mysql2/promise");
const dotenv = require("dotenv");
const path = require("path");

// .env dosyasını yükle
dotenv.config({ path: path.resolve(__dirname, "../.env.local") });

async function createFirmaBilgileriTable() {
  const config = {
    host: process.env.DB_HOST || "localhost",
    port: parseInt(process.env.DB_PORT || "3306"),
    user: process.env.DB_USER || "root",
    password: process.env.DB_PASSWORD || "",
    multipleStatements: true,
    insecureAuth: true,
  };

  const dbName = process.env.DB_NAME || "teknik_servis";

  try {
    console.log("Veritabanı bağlantısı kuruluyor...");

    const connection = await mysql.createConnection(config);
    await connection.query(`USE ${dbName}`);

    // Firma Bilgileri tablosunu oluştur
    console.log("Firma Bilgileri tablosu oluşturuluyor...");
    await connection.query(`
      CREATE TABLE IF NOT EXISTS firma_bilgileri (
        id INT AUTO_INCREMENT PRIMARY KEY,
        firma_adi VARCHAR(255) NOT NULL,
        firma_yetkilisi VARCHAR(255),
        telefon_1 VARCHAR(50),
        telefon_2 VARCHAR(50),
        email VARCHAR(255),
        adres TEXT,
        site_adresi VARCHAR(255),
        banka_adi VARCHAR(255),
        banka_hesap_sahibi_adi VARCHAR(255),
        iban_adresi VARCHAR(100),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
      ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    `);

    // Eğer tablo boşsa, varsayılan bir kayıt ekle
    const [rows]: any = await connection.query("SELECT COUNT(*) as count FROM firma_bilgileri");
    if (rows[0].count === 0) {
      console.log("Varsayılan kayıt ekleniyor...");
      await connection.query(`
        INSERT INTO firma_bilgileri (
          firma_adi, firma_yetkilisi, telefon_1, telefon_2, email, adres, 
          site_adresi, banka_adi, banka_hesap_sahibi_adi, iban_adresi
        ) VALUES (
          '', '', '', '', '', '', '', '', '', ''
        );
      `);
    }

    await connection.end();

    console.log("✅ Firma Bilgileri tablosu başarıyla oluşturuldu!");
  } catch (error: any) {
    console.error("❌ Hata:", error.message);
    process.exit(1);
  }
}

createFirmaBilgileriTable();

