# Admin Kullanıcı Oluşturma (Manuel Yöntem)

Eğer `npm run create-admin` komutu authentication hatası veriyorsa, admin kullanıcıyı manuel olarak oluşturabilirsiniz.

## Adım 1: MariaDB Authentication Plugin Sorununu Çözün

MariaDB'de şu komutu çalıştırın (phpMyAdmin veya MySQL komut satırından):

```sql
ALTER USER 'root'@'localhost' IDENTIFIED WITH mysql_native_password BY 'sifreniz';
FLUSH PRIVILEGES;
```

Veya `scripts/fix-auth-plugin.sql` dosyasını düzenleyip çalıştırın.

## Adım 2: Admin Kullanıcıyı Manuel Oluşturun

### Yöntem 1: Node.js Script ile (Şifre Hash'leme)

1. Node.js REPL'i açın:
```bash
node
```

2. Şu komutları çalıştırın:
```javascript
const bcrypt = require('bcryptjs');
bcrypt.hash('admin123', 10).then(hash => console.log(hash));
```

3. Çıkan hash değerini kopyalayın.

4. MariaDB'de şu komutu çalıştırın (hash değerini yapıştırın):
```sql
INSERT INTO users (username, password, email, full_name, role, is_active) 
VALUES ('admin', 'BURAYA_HASH_DEGERI_YAPIŞTIRIN', 'admin@teknikservis.com', 'Admin Kullanıcı', 'admin', TRUE)
ON DUPLICATE KEY UPDATE 
  password = VALUES(password),
  email = VALUES(email),
  full_name = VALUES(full_name),
  role = 'admin',
  is_active = TRUE;
```

### Yöntem 2: Online BCrypt Hash Generator

1. https://bcrypt-generator.com/ adresine gidin
2. Rounds: 10 seçin
3. Password: `admin123` (veya istediğiniz şifre) girin
4. Generate Hash butonuna tıklayın
5. Çıkan hash değerini kopyalayın
6. Yukarıdaki SQL komutunu hash ile çalıştırın

## Test

Giriş bilgileri:
- **Kullanıcı adı:** admin
- **Şifre:** admin123 (veya oluştururken kullandığınız şifre)

