/**
 * Users tablosuna telefon kolonu ekleme scripti
 * Kullanım: npm run add-telefon-column
 */

const mysql = require("mysql2/promise");
const dotenv = require("dotenv");
const path = require("path");

// .env dosyasını yükle
dotenv.config({ path: path.resolve(__dirname, "../.env.local") });

async function addTelefonColumn() {
  const config = {
    host: process.env.DB_HOST || "localhost",
    port: parseInt(process.env.DB_PORT || "3306"),
    user: process.env.DB_USER || "root",
    password: process.env.DB_PASSWORD || "",
    multipleStatements: true,
    insecureAuth: true,
  };

  const dbName = process.env.DB_NAME || "teknik_servis";

  try {
    console.log("Veritabanı bağlantısı kuruluyor...");

    const connection = await mysql.createConnection(config);
    await connection.query(`USE ${dbName}`);

    // Telefon kolonunu kontrol et ve ekle
    console.log("Telefon kolonu kontrol ediliyor...");
    const [columns]: any = await connection.query(`
      SELECT COLUMN_NAME 
      FROM INFORMATION_SCHEMA.COLUMNS 
      WHERE TABLE_SCHEMA = ? 
      AND TABLE_NAME = 'users' 
      AND COLUMN_NAME = 'telefon'
    `, [dbName]);

    if (columns.length === 0) {
      console.log("Telefon kolonu ekleniyor...");
      await connection.query(`
        ALTER TABLE users 
        ADD COLUMN telefon VARCHAR(50) AFTER email
      `);
      console.log("✅ Telefon kolonu başarıyla eklendi!");
    } else {
      console.log("ℹ️  Telefon kolonu zaten mevcut.");
    }

    await connection.end();
  } catch (error: any) {
    console.error("❌ Hata:", error.message);
    process.exit(1);
  }
}

addTelefonColumn();

