import mysql from "mysql2/promise";

// Veritabanı bağlantı havuzu oluştur
const pool = mysql.createPool({
  host: process.env.DB_HOST || "localhost",
  port: parseInt(process.env.DB_PORT || "3306"),
  user: process.env.DB_USER || "root",
  password: process.env.DB_PASSWORD || "",
  database: process.env.DB_NAME || "teknik_servis",
  waitForConnections: true,
  connectionLimit: 10,
  queueLimit: 0,
  enableKeepAlive: true,
  keepAliveInitialDelay: 0,
  insecureAuth: true,
});

// Veritabanı bağlantısını test et
export async function testConnection() {
  try {
    const connection = await pool.getConnection();
    console.log("✅ MariaDB bağlantısı başarılı!");
    connection.release();
    return true;
  } catch (error) {
    console.error("❌ MariaDB bağlantı hatası:", error);
    return false;
  }
}

// Veritabanı sorgusu çalıştır
export async function query(sql: string, params?: any[]) {
  try {
    const [results] = await pool.execute(sql, params);
    return results;
  } catch (error) {
    console.error("Veritabanı sorgu hatası:", error);
    throw error;
  }
}

// Transaction başlat
export async function getConnection() {
  return await pool.getConnection();
}

export default pool;

