-- Teknik Servis Veritabanı Şeması
-- Bu dosya veritabanı tablolarını oluşturmak için kullanılacak

-- Veritabanını oluştur (eğer yoksa)
CREATE DATABASE IF NOT EXISTS teknik_servis CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

USE teknik_servis;

-- Kullanıcılar tablosu (login için)
CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(50) UNIQUE NOT NULL,
  password VARCHAR(255) NOT NULL,
  email VARCHAR(100),
  full_name VARCHAR(100),
  role ENUM('admin', 'user', 'technician') DEFAULT 'user',
  is_active BOOLEAN DEFAULT TRUE,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  INDEX idx_username (username),
  INDEX idx_email (email)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Admin kullanıcı oluşturmak için scripts/create-admin-user.ts scriptini çalıştırın
-- veya manuel olarak bcrypt ile hash'lenmiş şifre ekleyin
-- Örnek: npm run create-admin

