"use client";

import { useState, useEffect } from "react";

export default function InternetConnectionChecker() {
  const [isOnline, setIsOnline] = useState(true);
  const [showModal, setShowModal] = useState(false);

  useEffect(() => {
    // İlk yüklemede bağlantı durumunu kontrol et
    setIsOnline(navigator.onLine);

    // Online event
    const handleOnline = () => {
      setIsOnline(true);
      setShowModal(false);
    };

    // Offline event
    const handleOffline = () => {
      setIsOnline(false);
      setShowModal(true);
    };

    // Event listener'ları ekle
    window.addEventListener("online", handleOnline);
    window.addEventListener("offline", handleOffline);

    // Cleanup
    return () => {
      window.removeEventListener("online", handleOnline);
      window.removeEventListener("offline", handleOffline);
    };
  }, []);

  if (!showModal) return null;

  return (
    <div className="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-50">
      <div className="bg-white dark:bg-gray-800 rounded-lg shadow-xl max-w-md w-full mx-4">
        <div className="p-6">
          {/* Icon */}
          <div className="flex items-center justify-center w-16 h-16 mx-auto mb-4 bg-red-100 dark:bg-red-900/20 rounded-full">
            <svg
              className="w-8 h-8 text-red-600 dark:text-red-400"
              fill="none"
              stroke="currentColor"
              viewBox="0 0 24 24"
            >
              <path
                strokeLinecap="round"
                strokeLinejoin="round"
                strokeWidth={2}
                d="M18.364 5.636a9 9 0 010 12.728m0 0l-2.829-2.829m2.829 2.829L21 21M15.536 8.464a5 5 0 010 7.072m0 0l-2.829-2.829m-4.243 2.829a4.978 4.978 0 01-1.414-2.83m-1.414 5.658a9 9 0 01-2.167-9.238m7.824 2.167a1 1 0 111.414 1.414m-1.414-1.414L3 3m8.293 8.293l1.414 1.414"
              />
            </svg>
          </div>

          {/* Title */}
          <h3 className="text-xl font-bold text-gray-900 dark:text-white text-center mb-2">
            İnternet Bağlantısı Yok
          </h3>

          {/* Message */}
          <p className="text-gray-600 dark:text-gray-400 text-center mb-6">
            İnternet bağlantınız kesilmiş görünüyor. Lütfen bağlantınızı kontrol edin.
          </p>

          {/* Loading Animation - Bağlantı beklenirken */}
          {!isOnline && (
            <div className="flex flex-col items-center justify-center mb-6">
              <div className="relative w-20 h-20 mb-4">
                {/* Spinning Circle */}
                <div className="absolute inset-0 border-4 border-red-200 dark:border-red-900/30 rounded-full"></div>
                <div className="absolute inset-0 border-4 border-transparent border-t-red-600 dark:border-t-red-400 rounded-full animate-spin"></div>
                {/* Inner Pulse */}
                <div className="absolute inset-4 bg-red-100 dark:bg-red-900/20 rounded-full animate-pulse"></div>
              </div>
              <span className="text-sm text-gray-600 dark:text-gray-400 font-medium">Bağlantı bekleniyor...</span>
            </div>
          )}

          {/* Close Button (sadece bağlantı geldiğinde görünür) */}
          {isOnline && (
            <button
              onClick={() => setShowModal(false)}
              className="w-full bg-green-600 hover:bg-green-700 text-white font-semibold py-3 px-4 rounded-lg transition-colors"
            >
              Bağlantı Geri Geldi - Kapat
            </button>
          )}

          {/* Offline durumunda sadece bilgi */}
          {!isOnline && (
            <div className="text-center">
              <p className="text-sm text-gray-500 dark:text-gray-400">
                Bağlantı geri geldiğinde bu pencere otomatik olarak kapanacaktır.
              </p>
            </div>
          )}
        </div>
      </div>
    </div>
  );
}

