import type { Metadata } from "next";
import "./globals.css";
import InternetConnectionChecker from "@/components/InternetConnectionChecker";

export const metadata: Metadata = {
  title: "Teknik Servis Yönetim Sistemi",
  description: "Teknik servis işlemlerinizi yönetin",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="tr">
      <body>
        {children}
        <InternetConnectionChecker />
      </body>
    </html>
  );
}

