import { NextResponse } from "next/server";
import { testConnection } from "@/lib/db";

export async function GET() {
  try {
    const isConnected = await testConnection();
    
    if (isConnected) {
      return NextResponse.json(
        { 
          success: true, 
          message: "MariaDB bağlantısı başarılı!" 
        },
        { status: 200 }
      );
    } else {
      return NextResponse.json(
        { 
          success: false, 
          message: "MariaDB bağlantısı başarısız!" 
        },
        { status: 500 }
      );
    }
  } catch (error: any) {
    return NextResponse.json(
      { 
        success: false, 
        message: "Veritabanı hatası",
        error: error.message 
      },
      { status: 500 }
    );
  }
}

