import { NextRequest, NextResponse } from "next/server";
import { query } from "@/lib/db";

// Firma bilgilerini getir
export async function GET() {
  try {
    const results: any = await query("SELECT * FROM firma_bilgileri ORDER BY id DESC LIMIT 1");

    if (Array.isArray(results) && results.length > 0) {
      return NextResponse.json(
        {
          success: true,
          data: results[0],
        },
        { status: 200 }
      );
    } else {
      // Eğer kayıt yoksa boş bir kayıt döndür
      return NextResponse.json(
        {
          success: true,
          data: {
            id: null,
            firma_adi: "",
            firma_yetkilisi: "",
            telefon_1: "",
            telefon_2: "",
            email: "",
            adres: "",
            site_adresi: "",
            banka_adi: "",
            banka_hesap_sahibi_adi: "",
            iban_adresi: "",
          },
        },
        { status: 200 }
      );
    }
  } catch (error: any) {
    console.error("Firma bilgileri getirme hatası:", error);
    return NextResponse.json(
      {
        success: false,
        message: "Firma bilgileri alınamadı",
        error: error.message,
      },
      { status: 500 }
    );
  }
}

// Firma bilgilerini güncelle veya oluştur
export async function PUT(request: NextRequest) {
  try {
    const body = await request.json();
    const {
      firma_adi,
      firma_yetkilisi,
      telefon_1,
      telefon_2,
      email,
      adres,
      site_adresi,
      banka_adi,
      banka_hesap_sahibi_adi,
      iban_adresi,
    } = body;

    // Validasyon
    if (!firma_adi || firma_adi.trim() === "") {
      return NextResponse.json(
        {
          success: false,
          message: "Firma adı zorunludur",
        },
        { status: 400 }
      );
    }

    // Önce mevcut kaydı kontrol et
    const existing: any = await query("SELECT id FROM firma_bilgileri ORDER BY id DESC LIMIT 1");

    if (Array.isArray(existing) && existing.length > 0) {
      // Mevcut kaydı güncelle
      await query(
        `UPDATE firma_bilgileri SET 
          firma_adi = ?,
          firma_yetkilisi = ?,
          telefon_1 = ?,
          telefon_2 = ?,
          email = ?,
          adres = ?,
          site_adresi = ?,
          banka_adi = ?,
          banka_hesap_sahibi_adi = ?,
          iban_adresi = ?
        WHERE id = ?`,
        [
          firma_adi,
          firma_yetkilisi || "",
          telefon_1 || "",
          telefon_2 || "",
          email || "",
          adres || "",
          site_adresi || "",
          banka_adi || "",
          banka_hesap_sahibi_adi || "",
          iban_adresi || "",
          existing[0].id,
        ]
      );

      return NextResponse.json(
        {
          success: true,
          message: "Firma bilgileri başarıyla güncellendi",
        },
        { status: 200 }
      );
    } else {
      // Yeni kayıt oluştur
      await query(
        `INSERT INTO firma_bilgileri (
          firma_adi, firma_yetkilisi, telefon_1, telefon_2, email, adres,
          site_adresi, banka_adi, banka_hesap_sahibi_adi, iban_adresi
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
        [
          firma_adi,
          firma_yetkilisi || "",
          telefon_1 || "",
          telefon_2 || "",
          email || "",
          adres || "",
          site_adresi || "",
          banka_adi || "",
          banka_hesap_sahibi_adi || "",
          iban_adresi || "",
        ]
      );

      return NextResponse.json(
        {
          success: true,
          message: "Firma bilgileri başarıyla kaydedildi",
        },
        { status: 201 }
      );
    }
  } catch (error: any) {
    console.error("Firma bilgileri güncelleme hatası:", error);
    return NextResponse.json(
      {
        success: false,
        message: "Firma bilgileri güncellenemedi",
        error: error.message,
      },
      { status: 500 }
    );
  }
}

