# Teknik Servis Yönetim Sistemi

Next.js ve MariaDB kullanılarak geliştirilmiş teknik servis yönetim sistemi.

## Kurulum

### 1. Bağımlılıkları Yükleyin

```bash
npm install
```

### 2. MariaDB Veritabanı Ayarları

`.env.local` dosyasını düzenleyerek veritabanı bilgilerinizi girin:

```env
DB_HOST=localhost
DB_PORT=3306
DB_USER=root
DB_PASSWORD=your_password
DB_NAME=teknik_servis
```

### 3. Veritabanını Oluşturun

MariaDB'ye bağlanın ve `lib/db-init.sql` dosyasını çalıştırın:

```bash
mysql -u root -p < lib/db-init.sql
```

Veya MariaDB komut satırından:

```sql
source lib/db-init.sql
```

### 4. Geliştirme Sunucusunu Başlatın

```bash
npm run dev
```

Tarayıcıda [http://localhost:3000](http://localhost:3000) adresine gidin.

## Veritabanı Bağlantısını Test Etme

Veritabanı bağlantısını test etmek için:

```bash
curl http://localhost:3000/api/test-db
```

## Proje Yapısı

```
├── app/                 # Next.js App Router
│   ├── api/            # API routes
│   ├── page.tsx        # Ana sayfa
│   └── layout.tsx      # Root layout
├── components/          # React bileşenleri
│   └── LoginPage.tsx   # Login sayfası
├── lib/                # Yardımcı fonksiyonlar
│   ├── db.ts           # MariaDB bağlantı yönetimi
│   └── db-init.sql     # Veritabanı şema dosyası
└── package.json        # Proje bağımlılıkları
```

## Teknolojiler

- **Next.js 14** - React framework
- **TypeScript** - Tip güvenliği
- **Tailwind CSS** - Stil framework'ü
- **MariaDB** - Veritabanı
- **mysql2** - MariaDB/MySQL bağlantı kütüphanesi

