# Paylaşımlı Hosting'e Deployment Rehberi

Bu rehber, Next.js projenizi paylaşımlı hosting'e nasıl yükleyeceğinizi açıklar.

## ⚠️ ÖNEMLİ: Hosting Gereksinimleri

Projeniz **Node.js desteği** gerektirir çünkü:
- API routes kullanıyor (`/api/*`)
- MariaDB bağlantısı var
- Server-side rendering yapıyor

### Node.js Destekli Hosting Önerileri (Türkiye)

- **Turhost** - Node.js desteği var
- **Natro** - Node.js desteği var
- **Hosting.com.tr** - Node.js desteği var
- **Turhost** - Node.js desteği var
- **DigitalOcean** (VPS) - Tam kontrol
- **Heroku** (Ücretsiz plan kaldırıldı)
- **Vercel** (Önerilen - Next.js için optimize)

## 📦 Deployment Adımları

### Yöntem 1: Node.js Destekli Paylaşımlı Hosting

#### 1. Projeyi Build Edin (Yerel Bilgisayarınızda)

```bash
# Bağımlılıkları yükleyin
npm install

# Production build oluşturun
npm run build
```

#### 2. Dosyaları FTP/cPanel ile Yükleyin

**Yüklenecek Dosyalar:**
```
├── .next/              # Build klasörü (ÖNEMLİ!)
├── node_modules/       # Bağımlılıklar
├── public/             # Statik dosyalar (varsa)
├── package.json
├── next.config.mjs
├── tsconfig.json
├── .env.local          # Veritabanı ayarları (GÜVENLİK: .gitignore'da olmalı)
└── ecosystem.config.js # PM2 için (opsiyonel)
```

**Yüklenecek Klasör:**
- Genellikle `public_html` veya `www` klasörü
- Veya hosting'in belirttiği Node.js uygulama klasörü

#### 3. cPanel'de Node.js Uygulaması Oluşturun

1. cPanel'e giriş yapın
2. **Node.js** veya **Node.js Selector** bölümünü bulun
3. Yeni uygulama oluşturun:
   - **Application Root**: `/home/kullaniciadi/public_html` (veya belirtilen klasör)
   - **Application URL**: `/` veya alt klasör
   - **Application Startup File**: `server.js` veya `node_modules/next/dist/bin/next start`
   - **Node.js Version**: 18.x veya 20.x (önerilen)

#### 4. Environment Variables Ayarlayın

cPanel'de Node.js uygulamanızın ayarlarından environment variables ekleyin:

```env
NODE_ENV=production
PORT=3000
DB_HOST=localhost
DB_PORT=3306
DB_USER=veritabani_kullanici_adi
DB_PASSWORD=veritabani_sifresi
DB_NAME=veritabani_adi
```

#### 5. Veritabanı Ayarları

1. cPanel'de **phpMyAdmin** veya **MySQL Databases** bölümüne gidin
2. Yeni veritabanı oluşturun
3. `lib/db-init.sql` dosyasını import edin
4. `.env.local` dosyasındaki veritabanı bilgilerini güncelleyin

#### 6. Uygulamayı Başlatın

cPanel'de Node.js uygulamanızı **Start** butonuna tıklayarak başlatın.

---

### Yöntem 2: Vercel (Önerilen - En Kolay)

Vercel Next.js için optimize edilmiştir ve ücretsiz plan sunar:

#### 1. GitHub'a Push Edin

```bash
git init
git add .
git commit -m "Initial commit"
git remote add origin https://github.com/kullaniciadi/teknik-servis.git
git push -u origin main
```

#### 2. Vercel'e Bağlayın

1. [vercel.com](https://vercel.com) hesabı oluşturun
2. **New Project** tıklayın
3. GitHub repo'nuzu seçin
4. Environment variables ekleyin:
   - `DB_HOST`
   - `DB_PORT`
   - `DB_USER`
   - `DB_PASSWORD`
   - `DB_NAME`
5. **Deploy** tıklayın

**Not:** Vercel'de MariaDB bağlantısı için external database kullanmanız gerekir (ör: PlanetScale, Railway, veya kendi MariaDB sunucunuz).

---

### Yöntem 3: Railway / Render (Alternatif)

Bu platformlar da Next.js'i destekler:

#### Railway

1. [railway.app](https://railway.app) hesabı oluşturun
2. **New Project** > **Deploy from GitHub**
3. Repo'nuzu seçin
4. Environment variables ekleyin
5. Otomatik deploy başlar

#### Render

1. [render.com](https://render.com) hesabı oluşturun
2. **New** > **Web Service**
3. GitHub repo'nuzu bağlayın
4. Build command: `npm run build`
5. Start command: `npm start`
6. Environment variables ekleyin

---

## 🔧 Sorun Giderme

### Port Hatası

Hosting'iniz belirli bir port kullanıyorsa, `package.json`'daki start script'ini güncelleyin:

```json
"start": "next start -p $PORT"
```

### Build Hatası

Yerel bilgisayarınızda build alırken hata alırsanız:

```bash
# Node modules'ü temizleyin
rm -rf node_modules package-lock.json
npm install
npm run build
```

### Veritabanı Bağlantı Hatası

- `.env.local` dosyasındaki bilgileri kontrol edin
- Hosting'inizin veritabanı host adresini kullanın (genellikle `localhost` değil, özel bir host)
- Firewall ayarlarını kontrol edin

### 404 Hatası

- `.htaccess` dosyasının doğru yapılandırıldığından emin olun
- Next.js'in doğru port'ta çalıştığını kontrol edin

---

## 📝 Önemli Notlar

1. **Güvenlik**: `.env.local` dosyasını asla Git'e commit etmeyin
2. **Performance**: Production'da `NODE_ENV=production` olduğundan emin olun
3. **Database**: Paylaşımlı hosting'de veritabanı host adresi genellikle `localhost` değildir
4. **SSL**: HTTPS kullanmak için Let's Encrypt sertifikası kurun (cPanel'de genellikle ücretsiz)

---

## 🆘 Destek

Sorun yaşarsanız:
1. Hosting sağlayıcınızın dokümantasyonunu kontrol edin
2. Node.js versiyonunu kontrol edin (18.x veya 20.x önerilir)
3. Log dosyalarını kontrol edin (`logs/` klasörü veya cPanel'de)

